'''
$Log: session.py,v $
Revision 1.2  2006/02/26 05:11:47  jangc
move bug is modifed

Revision 1.1.1.1  2005/03/12 03:29:58  jangc
start

Revision 1.2  2005/02/10 05:30:25  jangc
skin, webInterpace.py, wcmdr.py are added - jangc

Revision 1.3  2005/02/10 03:39:19  jangc
removeAllSession func is added - jangc

Revision 1.2  2005/02/10 03:36:07  jangc
remove function modified

Revision 1.1.1.1  2005/02/09 07:25:36  jangc
pySession

'''
import os
import md5
import time
import stat
import glob
import random
import shutil
import Cookie
import cPickle
import sessionConfig

random.seed(time.time())

class Session(object):
    def __init__(self, sid=None, **kw):
        if not os.path.exists(sessionConfig.sessionSavePath): 
            os.mkdir(sessionConfig.sessionSavePath) # FIXME permission
        self.sid = sid
        self.data = {}

        if self.isLive():
            self.loadData()
        else:
            self.sid = self.createID()
        self.path = os.path.join(sessionConfig.sessionSavePath, self.sid)
        self.burnCookie()
        self['sid'] = self.sid 
        self.data.update(kw)

        now = time.time()
        os.utime(self.path, (now, now))

    def loadData(self):
        self.data = cPickle.load(file(os.path.join(sessionConfig.sessionSavePath, self.sid)))
        
    def createID(self):
        m = md5.new(str(time.time()))
        return m.hexdigest()

    def burnCookie(self):
        cookie = Cookie.SimpleCookie()
        cookie['sid'] = self.sid
        #if self.sid.startswith('AUTO_'):
        #    cookie['sid']['expires'] = 60 * 60 * 24 * 365 # one year
        print cookie
 
    def isLive(self): 
        if not self.sid:
            return False
        sessionPath = os.path.join(sessionConfig.sessionSavePath, self.sid)
        if not os.path.exists(sessionPath):
            return False
        if os.stat(sessionPath)[stat.ST_MTIME] > (time.time() - int(sessionConfig.sessionLifeTime)):
            return True
        return False

    def suicide(self):
        if os.path.exists(self.path):
            os.remove(self.path)
        
    def __setitem__(self, name, value):
        self.data[name] = value
        sessionPath = os.path.join(sessionConfig.sessionSavePath, self.sid)
        cPickle.dump(self.data, open(sessionPath, 'w'))

    def __getitem__(self, name):
        return self.data.get(name)

def removeAllSessions():
    if os.path.exists(sessionConfig.sessionSavePath): 
        shutil.rmtree(sessionConfig.sessionSavePath)
    
def removeExpiredSessions():
    sidList = glob.glob(sessionConfig.sessionSavePath)
    for sid in sidList:
        session = Session(sid)
        if not session.isLive():
            session.suicide()

def removeExpiredSessionsByRandom():
    if random.randrange(101-int(sessionConfig.sessionRemoveProbability)) == 0:
        removeExpiredSessions()
