'''
    PyBB - Template Processor

    Copyright (c) 2003-2004 Gang Seong Lee <gslee@mail.kw.ac.kr>
    All rights reserved, see COPYING for details.
'''

import re
import sys, os
import StringIO
import stat
#import cPickle
import marshal
import cStringIO

TEXT, STATEMENT, EXPRESSION, INCLUDE = range(4)
debugMode = True

splitPattern = re.compile('<:(.*?):>', re.DOTALL)
def splitTeul(text, filePath):
    start = 0
    m = splitPattern.search(text)
    L = []
    while m:
        s, e = m.span()
        s += start
        e += start
        html = text[start:s]
        code = m.group(1)
        if html:
            L.append((TEXT, html))
        if code.startswith('#statements'):
            L.append((STATEMENT, code[len('#statements'):].lstrip()))
        elif code.startswith('#include'):
            fname = code.split()[1]
            dirPath = os.path.normpath(os.path.split(filePath)[0])
            while dirPath and not os.path.exists(os.path.join(dirPath, fname)):
                dirPath = os.path.split(dirPath)[0]
            path = os.path.join(dirPath, fname)
            s = file(path, 'r').read()
            L.extend(splitTeul(s, path))
        else:
            L.append((EXPRESSION, code))
        start = e
        m = splitPattern.search(text[start:])
    if text[start:]:
        L.append((TEXT, text[start:]))
    return L

def codeCompile(args):
    ctype, text = args
    if ctype in [TEXT, INCLUDE]:
        return args
    if ctype == EXPRESSION:
        return ctype, compile(text.lstrip(), '<string>', 'eval')
    if ctype == STATEMENT:
        return ctype, compile(text, '<string>', 'exec')

def putItTogether(blocks):
    L = []
    for ctype, text in blocks:
        if ctype == TEXT:
            L.append('sys.stdout.write("""%s""")' % text.replace('"', '\\"'))
        elif ctype == EXPRESSION:
            L.append('sys.stdout.write(str(%s))' % text)
        elif ctype == STATEMENT:
            L.append(text)
    return '\n'.join(L)
        
def makeTeulc(filePath):
    teul = file(filePath).read()
    blocks = splitTeul(teul, filePath)
    pythonCode = putItTogether(blocks)
    compiledCode = compile(pythonCode, '<string>', 'exec')
    #cPickle.dump(compiledCodeList, file(os.path.splitext(filePath)[0]+'.teulc', 'w'))
    marshal.dump(compiledCode, file(os.path.splitext(filePath)[0]+'.teulc', 'wb'))
    return compiledCode

def execCode(code, globalNS={}, localNS={}):
    try:
        localNS['sys'] = sys
        stdout = sys.stdout
        buf = StringIO.StringIO()
        sys.stdout = buf
        exec code in globalNS, localNS
        sys.stdout = stdout
        return buf.getvalue()
#        if ctype == INCLUDE:     # FIXME
#            path = os.path.join(config.skinPath, code)
#            compiledCodeList = getTemplate(path)
#            L = []
#            for compiledCode in compiledCodeList:
#                L.append(execCode(compiledCode, globalNS, localNS))
#            return ''.join(map(str, L))
        #if ctype == INCLUDE:
        #    return getTemplate(code)
    except Exception, errMsg:
        sys.stdout = stdout
        return 'ERROR:%s' % (str(errMsg))
            

def checkTeulIsModified(filePath, teulcPath):
    mtime = os.stat(filePath)[stat.ST_MTIME]
    mtimeOfTeulc = os.stat(teulcPath)[stat.ST_MTIME]
    if mtime >= mtimeOfTeulc:
        return True
    return False

def joinTextBlock(block1, block2):
    ctype1, text1 = block1
    ctype2, text2 = block2
    if ctype1 == ctype2 and ctype1 == TEXT:
        return (ctype1, text1+text2) 
    return block1, block2
        

templateTag = re.compile('<:(.*?(<:.*?:>.*?)*):>', re.DOTALL)
def templateProcessor(template, globalNS=None, localNS=None, currentDirPath=''):
    if globalNS == None:
        globalNS = {}
    if localNS == None:
        localNS = {}
    def repl(match):
        codeBlock = ''
        try:
            stdout = sys.stdout
            block = match.group(1).strip()
            if not block:
                return ''
            if block[0] != '#':
                return templateProcessor(str(eval(block, globalNS, localNS)), globalNS, localNS)
            lines = block.split('\n')
            line = lines[0]
            if line.strip() == '#statements':
                sbuf = StringIO.StringIO()
                codeBlock = '\n'.join(lines[1:]) + '\n'
                sys.stdout = sbuf
                exec codeBlock in globalNS, localNS
                sys.stdout = stdout
                return templateProcessor(sbuf.getvalue(), globalNS, localNS)
            elif line.startswith('#include'):
                fname = line.split()[1]
                dirPath = currentDirPath 
                path = os.path.join(dirPath, fname)
                return templateProcessor(getTemplate(path), globalNS, localNS, dirPath)
        except Exception, errMsg:
            import traceback
            s = StringIO.StringIO()
            traceback.print_exc(file=s)
            sys.stdout = stdout
            return 'Error<pre>%s\n%s\n</pre>' % (codeBlock, s.getvalue())
    if debugMode or type(template) == type(''):
        html = templateTag.sub(repl, template)
    else:
        html = execCode(template, globalNS, localNS)
    return html

#tempCache = {}
def getTemplateFromForum(path, forum_id=None):
    import bbslib
    try:
        community_id = bbslib.getCommunityIdFromForumId(forum_id)
        community = bbslib.getCommunity(community_id)
        forum = community.getForumById(forum_id)
        forumSkinPath = 'forum_%s_%s' % (forum.default_type, forum.skin_type)
    except:
        forumSkinPath = ''
    teulPath = path
    return os.path.split(teulPath)[0], getTemplate(teulPath)

def getTemplate(path):
    path = os.path.normpath(path)
    dirPath, fname = os.path.split(path)
    while True:
        filePath = os.path.join(dirPath, fname)
        if os.path.exists(filePath):
            break
        dirPath = os.path.split(dirPath)[0]
        skinPath = ''
        if dirPath in ('', '/', '\\') or not dirPath.replace('\\', '/').startswith(skinPath.replace('\\', '/')):
            raise IOError, 'failed to include %s file dirPath=%s skinPath=%s' % (fname, dirPath, skinPath)
    if debugMode:
        template = open(filePath).read()
        return template
#    template = tempCache.get(filePath)
    #if template:
    #    return template
    teulcPath = os.path.splitext(filePath)[0] + '.teulc'
    if os.path.exists(teulcPath) and not checkTeulIsModified(filePath, teulcPath):
        compiledCodeList = marshal.load(file(teulcPath, 'rb'))
    else:
        compiledCodeList = makeTeulc(filePath)
#    tempCache[filePath] = compiledCodeList 
    return compiledCodeList

