package net.kldp.j2ee.kupload;

import java.io.IOException;
import java.io.InputStream;

/**
 * FormFile 인터페이스
 */
public interface FormFile {
	/**
	 * 업로드 파일의 컨텐츠 타입을 돌려준다.
	 * 
	 * @return String ContentType
	 */
	public String getContentType();

	/**
	 * 업로드 파일 크기를 돌려준다.
	 * 
	 * @return int fileSize;
	 */
	public int getFileSize();

	/**
	 * 업로드 파일명을 돌려준다.
	 * 
	 * @return String fileName
	 */
	public String getFileName();

	/**
	 * 파일 확장자를 돌려준다.
	 * 
	 * @return String suffix;
	 */
	public String getFileSuffix();

	/**
	 * Form내에서의 필드명을 돌려준다.
	 * 
	 * @return String fieldName;
	 */
	public String getFieldName();

	/**
	 * 업로드한 데이터를 배열로 돌려준다.
	 * 
	 * @return byte[] data
	 * @throws IOException
	 */
	public byte[] getFileData() throws IOException;

	/**
	 * 업로드한 데이터의 스트림을 돌려준다.
	 * 
	 * @return inputStream
	 * @throws IOException
	 */
	public InputStream getInputStream() throws IOException;

	/**
	 * 업로드한 파일을 삭제한다.
	 */
	public void destroy();
}