package net.kldp.j2ee.kupload;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

/**
 * 업로드된 파일을 보관하는 클래스. request.getParamer와 형식이 같다.
 * 
 */
public class UploadFiles implements Iterable<FormFile> {
	private Hashtable<String, Hashtable<Integer, FormFile>> uploadFiles = new Hashtable<String, Hashtable<Integer, FormFile>>();
	private ArrayList<String> fieldNames = new ArrayList<String>();

	/**
	 * 파일을 삽입한다.
	 * 
	 * @param name
	 * @param file
	 */
	protected void putFile(String name, FormFile file) {
		if (name == null)
			throw new IllegalArgumentException("빈 요소를 삽입할 수 없습니다.");
		if (uploadFiles.containsKey(name)) {
			Hashtable<Integer, FormFile> values = uploadFiles.get(name);
			values.put(new Integer(values.size()), file);
		} else {
			Hashtable<Integer, FormFile> values = new Hashtable<Integer, FormFile>();
			values.put(new Integer(0), file);
			uploadFiles.put(name, values);
			fieldNames.add(file.getFieldName());
		}
	}

	/**
	 * 파일을 얻는다.
	 * 
	 * @param name
	 * @return file
	 */
	public FormFile getFile(String name) {
		if (name == null)
			throw new IllegalArgumentException("Form Field명이 null입니다. 처리되지 않습니다.");
		Hashtable<Integer, FormFile> values = uploadFiles.get(name);
		if (values == null)
			return null;
		else
			return values.get(new Integer(0));
	}

	/**
	 * 파일을 얻는다.
	 * 
	 * @param index
	 * @return file
	 */
	public FormFile getFile(int index) {
		if (index < 0 || fieldNames.size() <= index)
			throw new IllegalArgumentException("index is invalid.");
		String name = fieldNames.get(index);
		Hashtable<Integer, FormFile> values = uploadFiles.get(name);
		if (values == null)
			return null;
		else
			return values.get(new Integer(0));
	}

	/**
	 * 파일의 Enumeration을 리턴한다.
	 * 
	 * @return parameterNames
	 */
	public Enumeration<String> getFileNames() {
		return uploadFiles.keys();
	}

	/**
	 * 파일을 배열로 리턴한다.
	 * 
	 * @param name
	 * @return files
	 */
	public FormFile[] getFiles(String name) {
		if (name == null)
			throw new IllegalArgumentException("Form Field명이 null입니다. 처리되지 않습니다.");
		Hashtable<Integer, FormFile> values = uploadFiles.get(name);
		if (values == null)
			return null;
		FormFile files[] = new FormFile[values.size()];
		for (int i = 0; i < values.size(); i++)
			files[i] = values.get(new Integer(i));
		return files;
	}

	public Iterator<FormFile> iterator() {
		return new UploadFilesIterator(this);
	}

	/**
	 * 파일의 개수를 센다.
	 * @return files
	 */
	public int getCount() {
		return fieldNames.size();
	}

	@Override
	protected void finalize() throws Throwable {
		super.finalize();

		for (FormFile file : this) {
			file.destroy();
		}
		uploadFiles = null;
		fieldNames = null;
	}
}